/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.entity;

import dev.toma.gunsrpg.ai.AlwaysAggroOnGoal;
import dev.toma.gunsrpg.common.entity.BloodmoonGolemEntity;
import dev.toma.gunsrpg.common.entity.ExplosiveSkeletonEntity;
import dev.toma.gunsrpg.common.entity.RocketAngelEntity;
import dev.toma.gunsrpg.common.entity.ZombieGunnerEntity;
import dev.toma.gunsrpg.util.Interval;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.entity.boss.dragon.phase.ChargingPlayerPhase;
import net.minecraft.entity.boss.dragon.phase.PhaseManager;
import net.minecraft.entity.boss.dragon.phase.PhaseType;
import net.minecraft.entity.boss.dragon.phase.StrafePlayerPhase;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.server.ServerWorld;

public class GoldDragonEntity
extends EnderDragonEntity {
    private DragonStatsManager manager;
    private int cooldown;

    public GoldDragonEntity(EntityType<? extends GoldDragonEntity> type, World world) {
        super(type, world);
        this.field_184677_bJ = new ExtendedPhaseManager(this);
        if (!world.field_72995_K) {
            this.manager = new DragonStatsManager((ServerWorld)world, this.func_145748_c_());
        }
        this.resetCooldown();
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 1000.0);
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        return this.func_82195_e(p_70097_1_, p_70097_2_);
    }

    public boolean func_213403_a(EnderDragonPartEntity dragonPart, DamageSource source, float damage) {
        damage = this.func_184670_cT().func_188756_a().func_221113_a(source, damage);
        if (damage < 0.01f) {
            return false;
        }
        super.func_213403_a(dragonPart, source, damage);
        if (this.func_110143_aJ() <= 0.0f && !this.func_184670_cT().func_188756_a().func_188654_a()) {
            this.func_70606_j(1.0f);
            this.func_184670_cT().func_188758_a(PhaseType.field_188750_j);
        }
        return true;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_110143_aJ() < this.func_110138_aP() && this.field_70173_aa % 12 == 0) {
                this.func_70691_i(1.0f);
            }
            if (this.cooldown > 0) {
                --this.cooldown;
            }
        }
    }

    public void resetCooldown() {
        this.cooldown = Interval.minutes(1).getTicks();
    }

    public void func_70071_h_() {
        if (this.func_184670_cT().func_188756_a().func_188652_i() == PhaseType.field_188750_j) {
            this.func_213293_j(0.0, 0.0, 0.0);
        }
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.manager.tick(this);
            this.trySummonHelp();
        }
    }

    public void onRemovedFromWorld() {
        if (!this.field_70170_p.field_72995_K) {
            this.manager.end();
        }
        super.onRemovedFromWorld();
    }

    protected boolean func_82195_e(DamageSource source, float amount) {
        amount = (float)((double)amount * 0.6);
        boolean result = super.func_82195_e(source, amount);
        this.field_70172_ad = 0;
        return result;
    }

    public int func_184671_o() {
        if (this.field_184680_bM[0] == null) {
            for (int i = 0; i < 24; ++i) {
                int i1;
                int l;
                int j = 5;
                if (i < 12) {
                    l = (int)(60.0f * MathHelper.func_76134_b((float)(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i))));
                    i1 = (int)(60.0f * MathHelper.func_76126_a((float)(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i))));
                } else if (i < 20) {
                    int lvt_3_1_ = i - 12;
                    l = (int)(40.0f * MathHelper.func_76134_b((float)(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)lvt_3_1_))));
                    i1 = (int)(40.0f * MathHelper.func_76126_a((float)(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)lvt_3_1_))));
                    j += 10;
                } else {
                    int k1 = i - 20;
                    l = (int)(20.0f * MathHelper.func_76134_b((float)(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)k1))));
                    i1 = (int)(20.0f * MathHelper.func_76126_a((float)(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)k1))));
                }
                double x = this.func_226277_ct_();
                double z = this.func_226281_cx_();
                int j1 = Math.max(this.field_70170_p.func_181545_F() + 30, this.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, new BlockPos(x + (double)l, 0.0, z + (double)i1)).func_177956_o() + j);
                this.field_184680_bM[i] = new PathPoint((int)x + l, j1, (int)z + i1);
            }
            this.field_184681_bN[0] = 6146;
            this.field_184681_bN[1] = 8197;
            this.field_184681_bN[2] = 8202;
            this.field_184681_bN[3] = 16404;
            this.field_184681_bN[4] = 32808;
            this.field_184681_bN[5] = 32848;
            this.field_184681_bN[6] = 65696;
            this.field_184681_bN[7] = 131392;
            this.field_184681_bN[8] = 131712;
            this.field_184681_bN[9] = 263424;
            this.field_184681_bN[10] = 526848;
            this.field_184681_bN[11] = 525313;
            this.field_184681_bN[12] = 1581057;
            this.field_184681_bN[13] = 3166214;
            this.field_184681_bN[14] = 2138120;
            this.field_184681_bN[15] = 6373424;
            this.field_184681_bN[16] = 4358208;
            this.field_184681_bN[17] = 12910976;
            this.field_184681_bN[18] = 9044480;
            this.field_184681_bN[19] = 9706496;
            this.field_184681_bN[20] = 15216640;
            this.field_184681_bN[21] = 0xD0E000;
            this.field_184681_bN[22] = 11763712;
            this.field_184681_bN[23] = 0x7E0000;
        }
        return this.func_184663_l(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
    }

    private void trySummonHelp() {
        if (this.cooldown == 0) {
            this.resetCooldown();
            List players = this.field_70170_p.func_217369_A();
            for (PlayerEntity player : players) {
                double distance;
                if (player.func_175149_v() || !player.func_70089_S() || (distance = this.func_70068_e((Entity)player)) > 65536.0) continue;
                BlockPos pos = player.func_233580_cy_();
                this.spawnMob(pos, (LivingEntity)player, (MobEntity)new ZombieGunnerEntity(this.field_70170_p));
                this.spawnMob(pos, (LivingEntity)player, (MobEntity)new ExplosiveSkeletonEntity(this.field_70170_p));
                this.spawnMob(pos, (LivingEntity)player, (MobEntity)new RocketAngelEntity(this.field_70170_p), true);
                this.spawnMob(pos, (LivingEntity)player, (MobEntity)new BloodmoonGolemEntity(this.field_70170_p));
            }
        }
    }

    private void spawnMob(BlockPos pos, LivingEntity target, MobEntity mob) {
        this.spawnMob(pos, target, mob, false);
    }

    private void spawnMob(BlockPos pos, LivingEntity target, MobEntity mob, boolean airMob) {
        BlockPos spawnPos = this.genRandomPos(pos, this.field_70170_p, airMob);
        mob.func_70107_b((double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p());
        mob.func_70624_b(target);
        mob.field_70715_bh.func_75776_a(0, new AlwaysAggroOnGoal<LivingEntity>(mob, false, target));
        mob.func_213386_a((IServerWorld)((ServerWorld)this.field_70170_p), this.field_70170_p.func_175649_E(spawnPos), SpawnReason.REINFORCEMENT, null, null);
        this.field_70170_p.func_217376_c((Entity)mob);
    }

    private BlockPos genRandomPos(BlockPos pos, World world, boolean inAir) {
        int minDist = 24;
        int x = pos.func_177958_n() + (this.field_70146_Z.nextBoolean() ? -minDist : minDist);
        int z = pos.func_177952_p() + (this.field_70146_Z.nextBoolean() ? -minDist : minDist);
        int y = world.func_201676_a(Heightmap.Type.WORLD_SURFACE, x, z);
        if (inAir) {
            y += 16;
        }
        return new BlockPos(x, y, z);
    }

    public static class DragonStatsManager {
        private final Predicate<Entity> inRange;
        private final ServerWorld level;
        private final ServerBossInfo bossInfoServer;
        private Vector3d dragonPos;
        private int ticksSinceLastCheck;

        protected DragonStatsManager(ServerWorld _level, ITextComponent displayName) {
            this.level = _level;
            this.inRange = e -> {
                double maxRange = 36864.0;
                double dist = e.func_70092_e(this.dragonPos.field_72450_a, this.dragonPos.field_72448_b, this.dragonPos.field_72449_c);
                return e.func_70089_S() && dist <= maxRange;
            };
            this.bossInfoServer = (ServerBossInfo)new ServerBossInfo(displayName, BossInfo.Color.YELLOW, BossInfo.Overlay.PROGRESS).func_186743_c(true).func_186741_a(true);
            this.bossInfoServer.func_186758_d(true);
        }

        public void tick(GoldDragonEntity dragon) {
            this.bossInfoServer.func_186735_a(dragon.func_110143_aJ() / dragon.func_110138_aP());
            if (++this.ticksSinceLastCheck >= 20) {
                this.dragonPos = dragon.func_213303_ch();
                this.sendStatusUpdateToPlayers();
                this.ticksSinceLastCheck = 0;
            }
        }

        public void end() {
            this.bossInfoServer.func_201360_b();
            this.bossInfoServer.func_186758_d(false);
        }

        private void sendStatusUpdateToPlayers() {
            HashSet<ServerPlayerEntity> set = new HashSet<ServerPlayerEntity>();
            for (ServerPlayerEntity player : this.level.func_217490_a(this.inRange)) {
                this.bossInfoServer.func_186760_a(player);
                set.add(player);
            }
            HashSet set1 = new HashSet(this.bossInfoServer.func_186757_c());
            set1.removeAll(set);
            for (ServerPlayerEntity player : set1) {
                this.bossInfoServer.func_186761_b(player);
            }
        }
    }

    static class ExtendedPhaseManager
    extends PhaseManager {
        private final GoldDragonEntity goldDragon;

        public ExtendedPhaseManager(GoldDragonEntity dragon) {
            super((EnderDragonEntity)dragon);
            this.goldDragon = dragon;
        }

        public void func_188758_a(PhaseType<?> phaseIn) {
            boolean strafe = false;
            boolean charge = false;
            if (this.goldDragon == null) {
                super.func_188758_a(phaseIn);
                return;
            }
            PlayerEntity entitylivingbase = this.goldDragon.field_70170_p.func_217362_a((Entity)this.goldDragon, 150.0);
            if (phaseIn == PhaseType.field_188743_c) {
                if (entitylivingbase == null) {
                    phaseIn = PhaseType.field_188741_a;
                } else if (this.goldDragon.field_70146_Z.nextBoolean()) {
                    phaseIn = PhaseType.field_188742_b;
                    strafe = true;
                } else {
                    phaseIn = PhaseType.field_188749_i;
                    charge = true;
                }
            }
            super.func_188758_a(phaseIn);
            if (strafe) {
                if (entitylivingbase != null) {
                    ((StrafePlayerPhase)this.func_188757_b(PhaseType.field_188742_b)).func_188686_a((LivingEntity)entitylivingbase);
                }
            } else if (charge && entitylivingbase != null) {
                ((ChargingPlayerPhase)this.func_188757_b(PhaseType.field_188749_i)).func_188668_a(entitylivingbase.func_213303_ch());
            }
        }
    }
}

